/*
 * Decompiled with CFR 0.152.
 */
package mhzd.net.autoclick.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import mhzd.net.autoclick.network.DynamicData;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public class NetCodec {
    private final DynamicCodec dynamicCodec = new DynamicCodec();
    private final List<ObjectEncode> encodeList = new ArrayList<ObjectEncode>();
    private final Map<Class<?>, ObjectEncode> fastEncode = new ConcurrentHashMap();
    private final List<ObjectDecodeFactory> decodeList = new ArrayList<ObjectDecodeFactory>();
    private final Map<Class<?>, Function<ByteBuf, Object>> fastDecode = new ConcurrentHashMap();

    public NetCodec() {
        BooleanCodec booleanCodec = new BooleanCodec();
        this.encodeList.add(booleanCodec);
        this.decodeList.add(booleanCodec);
        IntCodec intCodec = new IntCodec();
        this.encodeList.add(intCodec);
        this.decodeList.add(intCodec);
        DoubleCodec doubleCodec = new DoubleCodec();
        this.encodeList.add(doubleCodec);
        this.decodeList.add(doubleCodec);
        FloatCodec floatCodec = new FloatCodec();
        this.encodeList.add(floatCodec);
        this.decodeList.add(floatCodec);
        StringCodec stringCodec = new StringCodec();
        this.encodeList.add(stringCodec);
        this.decodeList.add(stringCodec);
        UUIDCodec uuidCodec = new UUIDCodec();
        this.encodeList.add(uuidCodec);
        this.decodeList.add(uuidCodec);
        CollectionCodec collectionCodec = new CollectionCodec(this);
        this.encodeList.add(collectionCodec);
        this.decodeList.add(collectionCodec);
        NBTTagCompoundCodec nbtTagCompoundCodec = new NBTTagCompoundCodec();
        this.encodeList.add(nbtTagCompoundCodec);
        this.decodeList.add(nbtTagCompoundCodec);
        ItemStackCodec itemStackCodec = new ItemStackCodec(nbtTagCompoundCodec);
        this.encodeList.add(itemStackCodec);
        this.decodeList.add(itemStackCodec);
        this.encodeList.add(this.dynamicCodec);
        this.decodeList.add(this.dynamicCodec);
    }

    public <T extends DynamicData> void registerDynamicClass(Class<T> type, Function<ByteBuf, T> decode) {
        if (this.dynamicCodec.decodeIndex.putIfAbsent(type, this.dynamicCodec.decodeList.size()) == null) {
            this.dynamicCodec.decodeList.add(decode::apply);
        }
    }

    public FMLProxyPacket encodeMessage(String channel, String path, Object ... arguments) {
        ByteBuf buf = Unpooled.buffer();
        this.encode(buf, path);
        for (Object argument : arguments) {
            this.encode(buf, argument);
        }
        return new FMLProxyPacket(new PacketBuffer(buf), channel);
    }

    public boolean tryEncode(ByteBuf buf, Object val) {
        if (val == null) {
            throw new UnsupportedOperationException("can't encode null");
        }
        Class<?> clazz = val.getClass();
        ObjectEncode encode = this.fastEncode.get(clazz);
        if (encode != null) {
            encode.encode(buf, val);
            return true;
        }
        for (ObjectEncode e : this.encodeList) {
            if (!e.encode(buf, val)) continue;
            this.fastEncode.putIfAbsent(clazz, e);
            return true;
        }
        return false;
    }

    private void encode(ByteBuf buf, Object val) {
        if (!this.tryEncode(buf, val)) {
            throw new UnsupportedOperationException("can't find encode of " + val);
        }
    }

    @Nullable
    public Function<ByteBuf, Object> findDecode(Class<?> clazz) {
        Function<ByteBuf, Object> decode = this.fastDecode.get(clazz);
        if (decode != null) {
            return decode;
        }
        for (ObjectDecodeFactory f : this.decodeList) {
            decode = f.createDecode(clazz);
            if (decode == null) continue;
            this.fastDecode.putIfAbsent(clazz, decode);
            return decode;
        }
        return null;
    }

    public <E> E decode(ByteBuf buf, Class<E> clazz) {
        Function<ByteBuf, Object> decode = this.findDecode(clazz);
        if (decode != null) {
            return (E)decode.apply(buf);
        }
        throw new UnsupportedOperationException("can't find decode of " + clazz);
    }

    private static class DynamicCodec
    implements ObjectEncode,
    ObjectDecodeFactory {
        private final Map<Class<?>, Integer> decodeIndex = new HashMap();
        private final List<Function<ByteBuf, Object>> decodeList = new ArrayList<Function<ByteBuf, Object>>();

        private DynamicCodec() {
        }

        @Override
        public boolean encode(ByteBuf buf, Object val) {
            if (val instanceof DynamicData) {
                return this.encode0(buf, (DynamicData)val);
            }
            return false;
        }

        private boolean encode0(ByteBuf buf, DynamicData val) {
            int idx = this.decodeIndex.getOrDefault(val.getClass(), -1);
            if (idx < 0) {
                throw new UnsupportedOperationException("can't find decode of " + val + ", register class before use net");
            }
            buf.writeInt(idx);
            val.encode(buf);
            return true;
        }

        @Override
        @Nullable
        public Function<ByteBuf, Object> createDecode(Class<?> clazz) {
            if (DynamicData.class.isAssignableFrom(clazz)) {
                return buf -> this.decodeList.get(buf.readInt()).apply((ByteBuf)buf);
            }
            return null;
        }
    }

    private static class ItemStackCodec
    implements ObjectEncode,
    ObjectDecodeFactory {
        private final NBTTagCompoundCodec codec;

        private ItemStackCodec(NBTTagCompoundCodec codec) {
            this.codec = codec;
        }

        @Override
        public boolean encode(ByteBuf buf, Object val) {
            if (val instanceof ItemStack) {
                return this.codec.encode(buf, ((ItemStack)val).serializeNBT());
            }
            return false;
        }

        @Override
        @Nullable
        public Function<ByteBuf, Object> createDecode(Class<?> clazz) {
            return clazz == ItemStack.class ? this::decode : null;
        }

        private ItemStack decode(ByteBuf buf) {
            NBTTagCompound tagCompound = this.codec.decode(buf);
            return new ItemStack(tagCompound);
        }
    }

    private static class NBTTagCompoundCodec
    implements ObjectEncode,
    ObjectDecodeFactory {
        private NBTTagCompoundCodec() {
        }

        @Override
        public boolean encode(ByteBuf buf, Object val) {
            if (val instanceof NBTTagCompound) {
                try {
                    CompressedStreamTools.func_74799_a((NBTTagCompound)((NBTTagCompound)val), (OutputStream)new ByteBufOutputStream(buf));
                    return true;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return false;
        }

        @Override
        @Nullable
        public Function<ByteBuf, Object> createDecode(Class<?> clazz) {
            return clazz == NBTTagCompound.class ? this::decode : null;
        }

        private NBTTagCompound decode(ByteBuf buf) {
            try {
                return CompressedStreamTools.func_74796_a((InputStream)new ByteBufInputStream(buf));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ArrayDecode
    implements Function<ByteBuf, Object> {
        private final Class<?> componentType;
        private final Function<ByteBuf, Object> componentDecode;

        private ArrayDecode(Class<?> componentType, Function<ByteBuf, Object> componentDecode) {
            this.componentType = componentType;
            this.componentDecode = componentDecode;
        }

        @Override
        public Object apply(ByteBuf buf) {
            int len = buf.readShort();
            Object[] arr = (Object[])Array.newInstance(this.componentType, len);
            for (int i = 0; i < len; ++i) {
                arr[i] = this.componentDecode.apply(buf);
            }
            return arr;
        }
    }

    private static class CollectionCodec
    implements ObjectEncode,
    ObjectDecodeFactory {
        private final NetCodec codec;

        private CollectionCodec(NetCodec codec) {
            this.codec = codec;
        }

        @Override
        public boolean encode(ByteBuf buf, Object val) {
            if (val.getClass().isArray()) {
                List<Object> list;
                Object[] arr = (Object[])val;
                val = list = Arrays.asList(arr);
            }
            if (!(val instanceof Collection)) {
                return false;
            }
            int size = ((Collection)val).size();
            if (size > Short.MAX_VALUE) {
                throw new IllegalArgumentException("input is too long (" + size + ") to encode");
            }
            int i = buf.writerIndex();
            buf.writeShort(size);
            for (Object item : (Collection)val) {
                if (item == null) {
                    throw new UnsupportedOperationException("collection encode only support non-null collection");
                }
                if (item instanceof Collection || item.getClass().isArray()) {
                    throw new UnsupportedOperationException("collection encode only support one-dimension collection");
                }
                if (this.codec.tryEncode(buf, item)) continue;
                buf.writerIndex(i);
                return false;
            }
            return true;
        }

        @Override
        @Nullable
        public Function<ByteBuf, Object> createDecode(Class<?> clazz) {
            if (!clazz.isArray()) {
                return null;
            }
            Class<?> componentType = clazz.getComponentType();
            if (componentType.isArray()) {
                return null;
            }
            Function<ByteBuf, Object> componentDecode = this.codec.findDecode(componentType);
            if (componentDecode != null) {
                return new ArrayDecode(componentType, componentDecode);
            }
            return null;
        }
    }

    static class UUIDCodec
    implements ObjectEncode,
    ObjectDecodeFactory {
        UUIDCodec() {
        }

        @Override
        public boolean encode(ByteBuf buf, Object val) {
            if (val instanceof UUID) {
                this.encode0(buf, (UUID)val);
                return true;
            }
            return false;
        }

        private void encode0(ByteBuf buf, UUID val) {
            buf.writeLong(val.getMostSignificantBits());
            buf.writeLong(val.getLeastSignificantBits());
        }

        @Override
        @Nullable
        public Function<ByteBuf, Object> createDecode(Class<?> clazz) {
            return clazz.isAssignableFrom(UUID.class) ? this::decodeUUID : null;
        }

        private UUID decodeUUID(ByteBuf buf) {
            return new UUID(buf.readLong(), buf.readLong());
        }
    }

    static class StringCodec
    implements ObjectEncode,
    ObjectDecodeFactory {
        public static final int LENGTH_LIMITED = 8192;

        StringCodec() {
        }

        @Override
        public boolean encode(ByteBuf buf, Object val) {
            if (val instanceof CharSequence) {
                this.encode0(buf, (CharSequence)val);
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public Function<ByteBuf, Object> createDecode(Class<?> clazz) {
            return clazz.isAssignableFrom(String.class) ? this::decodeString : null;
        }

        public String decodeString(ByteBuf buf) {
            short len = buf.readShort();
            return buf.readCharSequence((int)len, StandardCharsets.UTF_8).toString();
        }

        private void encode0(ByteBuf buf, CharSequence cs) {
            int s1 = buf.writerIndex();
            buf.writeZero(2);
            int len = buf.writeCharSequence(cs, StandardCharsets.UTF_8);
            if (len > 8192) {
                throw new IllegalArgumentException("input is too long (" + len + ") to encode");
            }
            buf.setShort(s1, len);
        }
    }

    static class FloatCodec
    implements ObjectEncode,
    ObjectDecodeFactory {
        FloatCodec() {
        }

        @Override
        public boolean encode(ByteBuf buf, Object val) {
            if (val instanceof Float) {
                buf.writeFloat(((Float)val).floatValue());
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public Function<ByteBuf, Object> createDecode(Class<?> clazz) {
            return clazz == Float.TYPE ? this::decodeFloat : null;
        }

        public float decodeFloat(ByteBuf buf) {
            return buf.readFloat();
        }
    }

    static class DoubleCodec
    implements ObjectEncode,
    ObjectDecodeFactory {
        DoubleCodec() {
        }

        @Override
        public boolean encode(ByteBuf buf, Object val) {
            if (val instanceof Double) {
                buf.writeDouble(((Double)val).doubleValue());
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public Function<ByteBuf, Object> createDecode(Class<?> clazz) {
            return clazz == Double.TYPE ? this::decodeDouble : null;
        }

        public double decodeDouble(ByteBuf buf) {
            return buf.readDouble();
        }
    }

    static class IntCodec
    implements ObjectEncode,
    ObjectDecodeFactory {
        IntCodec() {
        }

        @Override
        public boolean encode(ByteBuf buf, Object val) {
            if (val instanceof Integer) {
                buf.writeInt(((Integer)val).intValue());
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public Function<ByteBuf, Object> createDecode(Class<?> clazz) {
            return clazz == Integer.TYPE ? this::decodeInt : null;
        }

        public int decodeInt(ByteBuf buf) {
            return buf.readInt();
        }
    }

    static class BooleanCodec
    implements ObjectEncode,
    ObjectDecodeFactory {
        BooleanCodec() {
        }

        @Override
        public boolean encode(ByteBuf buf, Object val) {
            if (val instanceof Boolean) {
                buf.writeBoolean(((Boolean)val).booleanValue());
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public Function<ByteBuf, Object> createDecode(Class<?> clazz) {
            return clazz == Boolean.TYPE ? this::decodeBoolean : null;
        }

        private Object decodeBoolean(ByteBuf buf) {
            return buf.readBoolean();
        }
    }

    static interface ObjectDecodeFactory {
        @Nullable
        public Function<ByteBuf, Object> createDecode(Class<?> var1);
    }

    static interface ObjectEncode {
        public boolean encode(ByteBuf var1, Object var2);
    }
}

